// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary>
    /// Contains configuration options specific to the algorithm used during indexing or querying.
    /// Please note <see cref="VectorSearchAlgorithmConfiguration"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="ExhaustiveKnnAlgorithmConfiguration"/> and <see cref="HnswAlgorithmConfiguration"/>.
    /// </summary>
    public abstract partial class VectorSearchAlgorithmConfiguration
    {
        /// <summary> Initializes a new instance of <see cref="VectorSearchAlgorithmConfiguration"/>. </summary>
        /// <param name="name"> The name to associate with this particular configuration. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        protected VectorSearchAlgorithmConfiguration(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="VectorSearchAlgorithmConfiguration"/>. </summary>
        /// <param name="name"> The name to associate with this particular configuration. </param>
        /// <param name="kind"> The name of the kind of algorithm being configured for use with vector search. </param>
        internal VectorSearchAlgorithmConfiguration(string name, VectorSearchAlgorithmKind kind)
        {
            Name = name;
            Kind = kind;
        }

        /// <summary> The name to associate with this particular configuration. </summary>
        public string Name { get; set; }
        /// <summary> The name of the kind of algorithm being configured for use with vector search. </summary>
        internal VectorSearchAlgorithmKind Kind { get; set; }
    }
}
