// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Search.Documents.Indexes.Models
{
    public partial class VectorSearch : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsCollectionDefined(Profiles))
            {
                writer.WritePropertyName("profiles"u8);
                writer.WriteStartArray();
                foreach (var item in Profiles)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Algorithms))
            {
                writer.WritePropertyName("algorithms"u8);
                writer.WriteStartArray();
                foreach (var item in Algorithms)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Vectorizers))
            {
                writer.WritePropertyName("vectorizers"u8);
                writer.WriteStartArray();
                foreach (var item in Vectorizers)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Compressions))
            {
                writer.WritePropertyName("compressions"u8);
                writer.WriteStartArray();
                foreach (var item in Compressions)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        internal static VectorSearch DeserializeVectorSearch(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<VectorSearchProfile> profiles = default;
            IList<VectorSearchAlgorithmConfiguration> algorithms = default;
            IList<VectorSearchVectorizer> vectorizers = default;
            IList<VectorSearchCompression> compressions = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("profiles"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<VectorSearchProfile> array = new List<VectorSearchProfile>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(VectorSearchProfile.DeserializeVectorSearchProfile(item));
                    }
                    profiles = array;
                    continue;
                }
                if (property.NameEquals("algorithms"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<VectorSearchAlgorithmConfiguration> array = new List<VectorSearchAlgorithmConfiguration>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(VectorSearchAlgorithmConfiguration.DeserializeVectorSearchAlgorithmConfiguration(item));
                    }
                    algorithms = array;
                    continue;
                }
                if (property.NameEquals("vectorizers"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<VectorSearchVectorizer> array = new List<VectorSearchVectorizer>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(VectorSearchVectorizer.DeserializeVectorSearchVectorizer(item));
                    }
                    vectorizers = array;
                    continue;
                }
                if (property.NameEquals("compressions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<VectorSearchCompression> array = new List<VectorSearchCompression>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(VectorSearchCompression.DeserializeVectorSearchCompression(item));
                    }
                    compressions = array;
                    continue;
                }
            }
            return new VectorSearch(profiles ?? new ChangeTrackingList<VectorSearchProfile>(), algorithms ?? new ChangeTrackingList<VectorSearchAlgorithmConfiguration>(), vectorizers ?? new ChangeTrackingList<VectorSearchVectorizer>(), compressions ?? new ChangeTrackingList<VectorSearchCompression>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static VectorSearch FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeVectorSearch(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
