// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Models
{
    /// <summary> Determines whether or not filters are applied before or after the vector search is performed. </summary>
    public readonly partial struct VectorFilterMode : IEquatable<VectorFilterMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VectorFilterMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VectorFilterMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PostFilterValue = "postFilter";
        private const string PreFilterValue = "preFilter";

        /// <summary> The filter will be applied after the candidate set of vector results is returned. Depending on the filter selectivity, this can result in fewer results than requested by the parameter 'k'. </summary>
        public static VectorFilterMode PostFilter { get; } = new VectorFilterMode(PostFilterValue);
        /// <summary> The filter will be applied before the search query. </summary>
        public static VectorFilterMode PreFilter { get; } = new VectorFilterMode(PreFilterValue);
        /// <summary> Determines if two <see cref="VectorFilterMode"/> values are the same. </summary>
        public static bool operator ==(VectorFilterMode left, VectorFilterMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VectorFilterMode"/> values are not the same. </summary>
        public static bool operator !=(VectorFilterMode left, VectorFilterMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VectorFilterMode"/>. </summary>
        public static implicit operator VectorFilterMode(string value) => new VectorFilterMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VectorFilterMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VectorFilterMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
