// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> The encoding format for interpreting vector field contents. </summary>
    public readonly partial struct VectorEncodingFormat : IEquatable<VectorEncodingFormat>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VectorEncodingFormat"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VectorEncodingFormat(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PackedBitValue = "packedBit";

        /// <summary> Encoding format representing bits packed into a wider data type. </summary>
        public static VectorEncodingFormat PackedBit { get; } = new VectorEncodingFormat(PackedBitValue);
        /// <summary> Determines if two <see cref="VectorEncodingFormat"/> values are the same. </summary>
        public static bool operator ==(VectorEncodingFormat left, VectorEncodingFormat right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VectorEncodingFormat"/> values are not the same. </summary>
        public static bool operator !=(VectorEncodingFormat left, VectorEncodingFormat right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VectorEncodingFormat"/>. </summary>
        public static implicit operator VectorEncodingFormat(string value) => new VectorEncodingFormat(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VectorEncodingFormat other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VectorEncodingFormat other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
