// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Search.Documents.Indexes.Models
{
    public partial class TextTranslationSkill : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("defaultToLanguageCode"u8);
            writer.WriteStringValue(DefaultToLanguageCode.ToString());
            if (Optional.IsDefined(DefaultFromLanguageCode))
            {
                if (DefaultFromLanguageCode != null)
                {
                    writer.WritePropertyName("defaultFromLanguageCode"u8);
                    writer.WriteStringValue(DefaultFromLanguageCode.Value.ToString());
                }
                else
                {
                    writer.WriteNull("defaultFromLanguageCode");
                }
            }
            if (Optional.IsDefined(SuggestedFrom))
            {
                if (SuggestedFrom != null)
                {
                    writer.WritePropertyName("suggestedFrom"u8);
                    writer.WriteStringValue(SuggestedFrom.Value.ToString());
                }
                else
                {
                    writer.WriteNull("suggestedFrom");
                }
            }
            writer.WritePropertyName("@odata.type"u8);
            writer.WriteStringValue(ODataType);
            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsDefined(Context))
            {
                writer.WritePropertyName("context"u8);
                writer.WriteStringValue(Context);
            }
            writer.WritePropertyName("inputs"u8);
            writer.WriteStartArray();
            foreach (var item in Inputs)
            {
                writer.WriteObjectValue<InputFieldMappingEntry>(item);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("outputs"u8);
            writer.WriteStartArray();
            foreach (var item in Outputs)
            {
                writer.WriteObjectValue<OutputFieldMappingEntry>(item);
            }
            writer.WriteEndArray();
            writer.WriteEndObject();
        }

        internal static TextTranslationSkill DeserializeTextTranslationSkill(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            TextTranslationSkillLanguage defaultToLanguageCode = default;
            TextTranslationSkillLanguage? defaultFromLanguageCode = default;
            TextTranslationSkillLanguage? suggestedFrom = default;
            string odataType = default;
            string name = default;
            string description = default;
            string context = default;
            IList<InputFieldMappingEntry> inputs = default;
            IList<OutputFieldMappingEntry> outputs = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("defaultToLanguageCode"u8))
                {
                    defaultToLanguageCode = new TextTranslationSkillLanguage(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("defaultFromLanguageCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        defaultFromLanguageCode = null;
                        continue;
                    }
                    defaultFromLanguageCode = new TextTranslationSkillLanguage(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("suggestedFrom"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        suggestedFrom = null;
                        continue;
                    }
                    suggestedFrom = new TextTranslationSkillLanguage(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("@odata.type"u8))
                {
                    odataType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("context"u8))
                {
                    context = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("inputs"u8))
                {
                    List<InputFieldMappingEntry> array = new List<InputFieldMappingEntry>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InputFieldMappingEntry.DeserializeInputFieldMappingEntry(item));
                    }
                    inputs = array;
                    continue;
                }
                if (property.NameEquals("outputs"u8))
                {
                    List<OutputFieldMappingEntry> array = new List<OutputFieldMappingEntry>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(OutputFieldMappingEntry.DeserializeOutputFieldMappingEntry(item));
                    }
                    outputs = array;
                    continue;
                }
            }
            return new TextTranslationSkill(
                odataType,
                name,
                description,
                context,
                inputs,
                outputs,
                defaultToLanguageCode,
                defaultFromLanguageCode,
                suggestedFrom);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new TextTranslationSkill FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeTextTranslationSkill(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal override RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
