// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> A value indicating which split mode to perform. </summary>
    public readonly partial struct TextSplitMode : IEquatable<TextSplitMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TextSplitMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TextSplitMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PagesValue = "pages";
        private const string SentencesValue = "sentences";

        /// <summary> Split the text into individual pages. </summary>
        public static TextSplitMode Pages { get; } = new TextSplitMode(PagesValue);
        /// <summary> Split the text into individual sentences. </summary>
        public static TextSplitMode Sentences { get; } = new TextSplitMode(SentencesValue);
        /// <summary> Determines if two <see cref="TextSplitMode"/> values are the same. </summary>
        public static bool operator ==(TextSplitMode left, TextSplitMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TextSplitMode"/> values are not the same. </summary>
        public static bool operator !=(TextSplitMode left, TextSplitMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TextSplitMode"/>. </summary>
        public static implicit operator TextSplitMode(string value) => new TextSplitMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TextSplitMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TextSplitMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
