// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Search.Documents.Models
{
    public partial class TextResult
    {
        internal static TextResult DeserializeTextResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            double? searchScore = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("searchScore"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    searchScore = property.Value.GetDouble();
                    continue;
                }
            }
            return new TextResult(searchScore);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static TextResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeTextResult(document.RootElement);
        }
    }
}
