// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Search.Documents.Models
{
    internal partial class SuggestDocumentsResult
    {
        internal static SuggestDocumentsResult DeserializeSuggestDocumentsResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<SuggestResult> value = default;
            double? searchCoverage = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    List<SuggestResult> array = new List<SuggestResult>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SuggestResult.DeserializeSuggestResult(item));
                    }
                    value = array;
                    continue;
                }
                if (property.NameEquals("@search.coverage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    searchCoverage = property.Value.GetDouble();
                    continue;
                }
            }
            return new SuggestDocumentsResult(value, searchCoverage);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SuggestDocumentsResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSuggestDocumentsResult(document.RootElement);
        }
    }
}
