// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> The language to use for a stemmer token filter. </summary>
    public enum StemmerTokenFilterLanguage
    {
        /// <summary> Selects the Lucene stemming tokenizer for Arabic. </summary>
        Arabic,
        /// <summary> Selects the Lucene stemming tokenizer for Armenian. </summary>
        Armenian,
        /// <summary> Selects the Lucene stemming tokenizer for Basque. </summary>
        Basque,
        /// <summary> Selects the Lucene stemming tokenizer for Portuguese (Brazil). </summary>
        Brazilian,
        /// <summary> Selects the Lucene stemming tokenizer for Bulgarian. </summary>
        Bulgarian,
        /// <summary> Selects the Lucene stemming tokenizer for Catalan. </summary>
        Catalan,
        /// <summary> Selects the Lucene stemming tokenizer for Czech. </summary>
        Czech,
        /// <summary> Selects the Lucene stemming tokenizer for Danish. </summary>
        Danish,
        /// <summary> Selects the Lucene stemming tokenizer for Dutch. </summary>
        Dutch,
        /// <summary> Selects the Lucene stemming tokenizer for Dutch that uses the Kraaij-Pohlmann stemming algorithm. </summary>
        DutchKp,
        /// <summary> Selects the Lucene stemming tokenizer for English. </summary>
        English,
        /// <summary> Selects the Lucene stemming tokenizer for English that does light stemming. </summary>
        LightEnglish,
        /// <summary> Selects the Lucene stemming tokenizer for English that does minimal stemming. </summary>
        MinimalEnglish,
        /// <summary> Selects the Lucene stemming tokenizer for English that removes trailing possessives from words. </summary>
        PossessiveEnglish,
        /// <summary> Selects the Lucene stemming tokenizer for English that uses the Porter2 stemming algorithm. </summary>
        Porter2,
        /// <summary> Selects the Lucene stemming tokenizer for English that uses the Lovins stemming algorithm. </summary>
        Lovins,
        /// <summary> Selects the Lucene stemming tokenizer for Finnish. </summary>
        Finnish,
        /// <summary> Selects the Lucene stemming tokenizer for Finnish that does light stemming. </summary>
        LightFinnish,
        /// <summary> Selects the Lucene stemming tokenizer for French. </summary>
        French,
        /// <summary> Selects the Lucene stemming tokenizer for French that does light stemming. </summary>
        LightFrench,
        /// <summary> Selects the Lucene stemming tokenizer for French that does minimal stemming. </summary>
        MinimalFrench,
        /// <summary> Selects the Lucene stemming tokenizer for Galician. </summary>
        Galician,
        /// <summary> Selects the Lucene stemming tokenizer for Galician that does minimal stemming. </summary>
        MinimalGalician,
        /// <summary> Selects the Lucene stemming tokenizer for German. </summary>
        German,
        /// <summary> Selects the Lucene stemming tokenizer that uses the German variant algorithm. </summary>
        German2,
        /// <summary> Selects the Lucene stemming tokenizer for German that does light stemming. </summary>
        LightGerman,
        /// <summary> Selects the Lucene stemming tokenizer for German that does minimal stemming. </summary>
        MinimalGerman,
        /// <summary> Selects the Lucene stemming tokenizer for Greek. </summary>
        Greek,
        /// <summary> Selects the Lucene stemming tokenizer for Hindi. </summary>
        Hindi,
        /// <summary> Selects the Lucene stemming tokenizer for Hungarian. </summary>
        Hungarian,
        /// <summary> Selects the Lucene stemming tokenizer for Hungarian that does light stemming. </summary>
        LightHungarian,
        /// <summary> Selects the Lucene stemming tokenizer for Indonesian. </summary>
        Indonesian,
        /// <summary> Selects the Lucene stemming tokenizer for Irish. </summary>
        Irish,
        /// <summary> Selects the Lucene stemming tokenizer for Italian. </summary>
        Italian,
        /// <summary> Selects the Lucene stemming tokenizer for Italian that does light stemming. </summary>
        LightItalian,
        /// <summary> Selects the Lucene stemming tokenizer for Sorani. </summary>
        Sorani,
        /// <summary> Selects the Lucene stemming tokenizer for Latvian. </summary>
        Latvian,
        /// <summary> Selects the Lucene stemming tokenizer for Norwegian (Bokmål). </summary>
        Norwegian,
        /// <summary> Selects the Lucene stemming tokenizer for Norwegian (Bokmål) that does light stemming. </summary>
        LightNorwegian,
        /// <summary> Selects the Lucene stemming tokenizer for Norwegian (Bokmål) that does minimal stemming. </summary>
        MinimalNorwegian,
        /// <summary> Selects the Lucene stemming tokenizer for Norwegian (Nynorsk) that does light stemming. </summary>
        LightNynorsk,
        /// <summary> Selects the Lucene stemming tokenizer for Norwegian (Nynorsk) that does minimal stemming. </summary>
        MinimalNynorsk,
        /// <summary> Selects the Lucene stemming tokenizer for Portuguese. </summary>
        Portuguese,
        /// <summary> Selects the Lucene stemming tokenizer for Portuguese that does light stemming. </summary>
        LightPortuguese,
        /// <summary> Selects the Lucene stemming tokenizer for Portuguese that does minimal stemming. </summary>
        MinimalPortuguese,
        /// <summary> Selects the Lucene stemming tokenizer for Portuguese that uses the RSLP stemming algorithm. </summary>
        PortugueseRslp,
        /// <summary> Selects the Lucene stemming tokenizer for Romanian. </summary>
        Romanian,
        /// <summary> Selects the Lucene stemming tokenizer for Russian. </summary>
        Russian,
        /// <summary> Selects the Lucene stemming tokenizer for Russian that does light stemming. </summary>
        LightRussian,
        /// <summary> Selects the Lucene stemming tokenizer for Spanish. </summary>
        Spanish,
        /// <summary> Selects the Lucene stemming tokenizer for Spanish that does light stemming. </summary>
        LightSpanish,
        /// <summary> Selects the Lucene stemming tokenizer for Swedish. </summary>
        Swedish,
        /// <summary> Selects the Lucene stemming tokenizer for Swedish that does light stemming. </summary>
        LightSwedish,
        /// <summary> Selects the Lucene stemming tokenizer for Turkish. </summary>
        Turkish
    }
}
