// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> A value indicating which unit to use. </summary>
    public readonly partial struct SplitSkillUnit : IEquatable<SplitSkillUnit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SplitSkillUnit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SplitSkillUnit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CharactersValue = "characters";
        private const string AzureOpenAITokensValue = "azureOpenAITokens";

        /// <summary> The length will be measured by character. </summary>
        public static SplitSkillUnit Characters { get; } = new SplitSkillUnit(CharactersValue);
        /// <summary> The length will be measured by an AzureOpenAI tokenizer from the tiktoken library. </summary>
        public static SplitSkillUnit AzureOpenAITokens { get; } = new SplitSkillUnit(AzureOpenAITokensValue);
        /// <summary> Determines if two <see cref="SplitSkillUnit"/> values are the same. </summary>
        public static bool operator ==(SplitSkillUnit left, SplitSkillUnit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SplitSkillUnit"/> values are not the same. </summary>
        public static bool operator !=(SplitSkillUnit left, SplitSkillUnit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SplitSkillUnit"/>. </summary>
        public static implicit operator SplitSkillUnit(string value) => new SplitSkillUnit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SplitSkillUnit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SplitSkillUnit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
