// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Defines a data deletion detection policy that implements a soft-deletion strategy. It determines whether an item should be deleted based on the value of a designated 'soft delete' column. </summary>
    public partial class SoftDeleteColumnDeletionDetectionPolicy : DataDeletionDetectionPolicy
    {
        /// <summary> Initializes a new instance of <see cref="SoftDeleteColumnDeletionDetectionPolicy"/>. </summary>
        public SoftDeleteColumnDeletionDetectionPolicy()
        {
            ODataType = "#Microsoft.Azure.Search.SoftDeleteColumnDeletionDetectionPolicy";
        }

        /// <summary> Initializes a new instance of <see cref="SoftDeleteColumnDeletionDetectionPolicy"/>. </summary>
        /// <param name="oDataType"> A URI fragment specifying the type of data deletion detection policy. </param>
        /// <param name="softDeleteColumnName"> The name of the column to use for soft-deletion detection. </param>
        /// <param name="softDeleteMarkerValue"> The marker value that identifies an item as deleted. </param>
        internal SoftDeleteColumnDeletionDetectionPolicy(string oDataType, string softDeleteColumnName, string softDeleteMarkerValue) : base(oDataType)
        {
            SoftDeleteColumnName = softDeleteColumnName;
            SoftDeleteMarkerValue = softDeleteMarkerValue;
            ODataType = oDataType ?? "#Microsoft.Azure.Search.SoftDeleteColumnDeletionDetectionPolicy";
        }

        /// <summary> The name of the column to use for soft-deletion detection. </summary>
        public string SoftDeleteColumnName { get; set; }
        /// <summary> The marker value that identifies an item as deleted. </summary>
        public string SoftDeleteMarkerValue { get; set; }
    }
}
