// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> The language to use for a Snowball token filter. </summary>
    public enum SnowballTokenFilterLanguage
    {
        /// <summary> Selects the Lucene Snowball stemming tokenizer for Armenian. </summary>
        Armenian,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for Basque. </summary>
        Basque,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for Catalan. </summary>
        Catalan,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for Danish. </summary>
        Danish,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for Dutch. </summary>
        Dutch,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for English. </summary>
        English,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for Finnish. </summary>
        Finnish,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for French. </summary>
        French,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for German. </summary>
        German,
        /// <summary> Selects the Lucene Snowball stemming tokenizer that uses the German variant algorithm. </summary>
        German2,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for Hungarian. </summary>
        Hungarian,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for Italian. </summary>
        Italian,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for Dutch that uses the Kraaij-Pohlmann stemming algorithm. </summary>
        Kp,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for English that uses the Lovins stemming algorithm. </summary>
        Lovins,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for Norwegian. </summary>
        Norwegian,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for English that uses the Porter stemming algorithm. </summary>
        Porter,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for Portuguese. </summary>
        Portuguese,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for Romanian. </summary>
        Romanian,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for Russian. </summary>
        Russian,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for Spanish. </summary>
        Spanish,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for Swedish. </summary>
        Swedish,
        /// <summary> Selects the Lucene Snowball stemming tokenizer for Turkish. </summary>
        Turkish
    }
}
