// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Search.Documents.Models
{
    public partial class SingleVectorFieldResult
    {
        internal static SingleVectorFieldResult DeserializeSingleVectorFieldResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            double? searchScore = default;
            double? vectorSimilarity = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("searchScore"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    searchScore = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("vectorSimilarity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    vectorSimilarity = property.Value.GetDouble();
                    continue;
                }
            }
            return new SingleVectorFieldResult(searchScore, vectorSimilarity);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SingleVectorFieldResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSingleVectorFieldResult(document.RootElement);
        }
    }
}
