// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Search.Documents.Indexes.Models
{
    public partial class SemanticSearch : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(DefaultConfigurationName))
            {
                writer.WritePropertyName("defaultConfiguration"u8);
                writer.WriteStringValue(DefaultConfigurationName);
            }
            if (Optional.IsCollectionDefined(Configurations))
            {
                writer.WritePropertyName("configurations"u8);
                writer.WriteStartArray();
                foreach (var item in Configurations)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        internal static SemanticSearch DeserializeSemanticSearch(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string defaultConfiguration = default;
            IList<SemanticConfiguration> configurations = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("defaultConfiguration"u8))
                {
                    defaultConfiguration = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("configurations"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SemanticConfiguration> array = new List<SemanticConfiguration>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SemanticConfiguration.DeserializeSemanticConfiguration(item));
                    }
                    configurations = array;
                    continue;
                }
            }
            return new SemanticSearch(defaultConfiguration, configurations ?? new ChangeTrackingList<SemanticConfiguration>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SemanticSearch FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSemanticSearch(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
