// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> A field that is used as part of the semantic configuration. </summary>
    public partial class SemanticField
    {
        /// <summary> Initializes a new instance of <see cref="SemanticField"/>. </summary>
        /// <param name="fieldName"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="fieldName"/> is null. </exception>
        public SemanticField(string fieldName)
        {
            Argument.AssertNotNull(fieldName, nameof(fieldName));

            FieldName = fieldName;
        }

        /// <summary> Gets or sets the field name. </summary>
        public string FieldName { get; set; }
    }
}
