// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Models
{
    /// <summary> Reason that a partial response was returned for a semantic ranking request. </summary>
    public readonly partial struct SemanticErrorReason : IEquatable<SemanticErrorReason>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SemanticErrorReason"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SemanticErrorReason(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MaxWaitExceededValue = "maxWaitExceeded";
        private const string CapacityOverloadedValue = "capacityOverloaded";
        private const string TransientValue = "transient";

        /// <summary> If `semanticMaxWaitInMilliseconds` was set and the semantic processing duration exceeded that value. Only the base results were returned. </summary>
        public static SemanticErrorReason MaxWaitExceeded { get; } = new SemanticErrorReason(MaxWaitExceededValue);
        /// <summary> The request was throttled. Only the base results were returned. </summary>
        public static SemanticErrorReason CapacityOverloaded { get; } = new SemanticErrorReason(CapacityOverloadedValue);
        /// <summary> At least one step of the semantic process failed. </summary>
        public static SemanticErrorReason Transient { get; } = new SemanticErrorReason(TransientValue);
        /// <summary> Determines if two <see cref="SemanticErrorReason"/> values are the same. </summary>
        public static bool operator ==(SemanticErrorReason left, SemanticErrorReason right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SemanticErrorReason"/> values are not the same. </summary>
        public static bool operator !=(SemanticErrorReason left, SemanticErrorReason right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SemanticErrorReason"/>. </summary>
        public static implicit operator SemanticErrorReason(string value) => new SemanticErrorReason(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SemanticErrorReason other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SemanticErrorReason other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
