// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Models
{
    /// <summary> Allows the user to choose whether a semantic call should fail completely, or to return partial results. </summary>
    public readonly partial struct SemanticErrorMode : IEquatable<SemanticErrorMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SemanticErrorMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SemanticErrorMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PartialValue = "partial";
        private const string FailValue = "fail";

        /// <summary> If the semantic processing fails, partial results still return. The definition of partial results depends on what semantic step failed and what was the reason for failure. </summary>
        public static SemanticErrorMode Partial { get; } = new SemanticErrorMode(PartialValue);
        /// <summary> If there is an exception during the semantic processing step, the query will fail and return the appropriate HTTP code depending on the error. </summary>
        public static SemanticErrorMode Fail { get; } = new SemanticErrorMode(FailValue);
        /// <summary> Determines if two <see cref="SemanticErrorMode"/> values are the same. </summary>
        public static bool operator ==(SemanticErrorMode left, SemanticErrorMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SemanticErrorMode"/> values are not the same. </summary>
        public static bool operator !=(SemanticErrorMode left, SemanticErrorMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SemanticErrorMode"/>. </summary>
        public static implicit operator SemanticErrorMode(string value) => new SemanticErrorMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SemanticErrorMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SemanticErrorMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
