// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Search.Documents.Indexes.Models
{
    public partial class SearchServiceStatistics
    {
        internal static SearchServiceStatistics DeserializeSearchServiceStatistics(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            SearchServiceCounters counters = default;
            SearchServiceLimits limits = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("counters"u8))
                {
                    counters = SearchServiceCounters.DeserializeSearchServiceCounters(property.Value);
                    continue;
                }
                if (property.NameEquals("limits"u8))
                {
                    limits = SearchServiceLimits.DeserializeSearchServiceLimits(property.Value);
                    continue;
                }
            }
            return new SearchServiceStatistics(counters, limits);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SearchServiceStatistics FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSearchServiceStatistics(document.RootElement);
        }
    }
}
