// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Search.Documents.Indexes.Models
{
    public partial class SearchServiceLimits
    {
        internal static SearchServiceLimits DeserializeSearchServiceLimits(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? maxFieldsPerIndex = default;
            int? maxFieldNestingDepthPerIndex = default;
            int? maxComplexCollectionFieldsPerIndex = default;
            int? maxComplexObjectsInCollectionsPerDocument = default;
            long? maxStoragePerIndex = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("maxFieldsPerIndex"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        maxFieldsPerIndex = null;
                        continue;
                    }
                    maxFieldsPerIndex = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxFieldNestingDepthPerIndex"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        maxFieldNestingDepthPerIndex = null;
                        continue;
                    }
                    maxFieldNestingDepthPerIndex = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxComplexCollectionFieldsPerIndex"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        maxComplexCollectionFieldsPerIndex = null;
                        continue;
                    }
                    maxComplexCollectionFieldsPerIndex = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxComplexObjectsInCollectionsPerDocument"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        maxComplexObjectsInCollectionsPerDocument = null;
                        continue;
                    }
                    maxComplexObjectsInCollectionsPerDocument = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxStoragePerIndex"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        maxStoragePerIndex = null;
                        continue;
                    }
                    maxStoragePerIndex = property.Value.GetInt64();
                    continue;
                }
            }
            return new SearchServiceLimits(maxFieldsPerIndex, maxFieldNestingDepthPerIndex, maxComplexCollectionFieldsPerIndex, maxComplexObjectsInCollectionsPerDocument, maxStoragePerIndex);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SearchServiceLimits FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSearchServiceLimits(document.RootElement);
        }
    }
}
