// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Search.Documents.Indexes.Models
{
    public partial class SearchResourceCounter
    {
        internal static SearchResourceCounter DeserializeSearchResourceCounter(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            long usage = default;
            long? quota = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("usage"u8))
                {
                    usage = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("quota"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        quota = null;
                        continue;
                    }
                    quota = property.Value.GetInt64();
                    continue;
                }
            }
            return new SearchResourceCounter(usage, quota);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SearchResourceCounter FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSearchResourceCounter(document.RootElement);
        }
    }
}
