// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Search.Documents.Models
{
    internal static partial class SearchModeExtensions
    {
        public static string ToSerialString(this SearchMode value) => value switch
        {
            SearchMode.Any => "any",
            SearchMode.All => "all",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SearchMode value.")
        };

        public static SearchMode ToSearchMode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "any")) return SearchMode.Any;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "all")) return SearchMode.All;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SearchMode value.");
        }
    }
}
