// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Search.Documents.Indexes.Models
{
    public partial class SearchIndexerSkillset : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("name"u8);
            writer.WriteStringValue(Name);
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            writer.WritePropertyName("skills"u8);
            writer.WriteStartArray();
            foreach (var item in Skills)
            {
                writer.WriteObjectValue<SearchIndexerSkill>(item);
            }
            writer.WriteEndArray();
            if (Optional.IsDefined(CognitiveServicesAccount))
            {
                writer.WritePropertyName("cognitiveServices"u8);
                writer.WriteObjectValue(CognitiveServicesAccount);
            }
            if (Optional.IsDefined(KnowledgeStore))
            {
                writer.WritePropertyName("knowledgeStore"u8);
                writer.WriteObjectValue(KnowledgeStore);
            }
            if (Optional.IsDefined(IndexProjection))
            {
                writer.WritePropertyName("indexProjections"u8);
                writer.WriteObjectValue(IndexProjection);
            }
            if (Optional.IsDefined(_etag))
            {
                writer.WritePropertyName("@odata.etag"u8);
                writer.WriteStringValue(_etag);
            }
            if (Optional.IsDefined(EncryptionKey))
            {
                if (EncryptionKey != null)
                {
                    writer.WritePropertyName("encryptionKey"u8);
                    writer.WriteObjectValue(EncryptionKey);
                }
                else
                {
                    writer.WriteNull("encryptionKey");
                }
            }
            writer.WriteEndObject();
        }

        internal static SearchIndexerSkillset DeserializeSearchIndexerSkillset(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            string description = default;
            IList<SearchIndexerSkill> skills = default;
            CognitiveServicesAccount cognitiveServices = default;
            KnowledgeStore knowledgeStore = default;
            SearchIndexerIndexProjection indexProjections = default;
            string odataEtag = default;
            SearchResourceEncryptionKey encryptionKey = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("skills"u8))
                {
                    List<SearchIndexerSkill> array = new List<SearchIndexerSkill>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SearchIndexerSkill.DeserializeSearchIndexerSkill(item));
                    }
                    skills = array;
                    continue;
                }
                if (property.NameEquals("cognitiveServices"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cognitiveServices = CognitiveServicesAccount.DeserializeCognitiveServicesAccount(property.Value);
                    continue;
                }
                if (property.NameEquals("knowledgeStore"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    knowledgeStore = KnowledgeStore.DeserializeKnowledgeStore(property.Value);
                    continue;
                }
                if (property.NameEquals("indexProjections"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    indexProjections = SearchIndexerIndexProjection.DeserializeSearchIndexerIndexProjection(property.Value);
                    continue;
                }
                if (property.NameEquals("@odata.etag"u8))
                {
                    odataEtag = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("encryptionKey"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        encryptionKey = null;
                        continue;
                    }
                    encryptionKey = SearchResourceEncryptionKey.DeserializeSearchResourceEncryptionKey(property.Value);
                    continue;
                }
            }
            return new SearchIndexerSkillset(
                name,
                description,
                skills,
                cognitiveServices,
                knowledgeStore,
                indexProjections,
                odataEtag,
                encryptionKey);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SearchIndexerSkillset FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSearchIndexerSkillset(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
