// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Description for what data to store in the designated search index. </summary>
    public partial class SearchIndexerIndexProjectionSelector
    {
        /// <summary> Initializes a new instance of <see cref="SearchIndexerIndexProjectionSelector"/>. </summary>
        /// <param name="targetIndexName"> Name of the search index to project to. Must have a key field with the 'keyword' analyzer set. </param>
        /// <param name="parentKeyFieldName"> Name of the field in the search index to map the parent document's key value to. Must be a string field that is filterable and not the key field. </param>
        /// <param name="sourceContext"> Source context for the projections. Represents the cardinality at which the document will be split into multiple sub documents. </param>
        /// <param name="mappings"> Mappings for the projection, or which source should be mapped to which field in the target index. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="targetIndexName"/>, <paramref name="parentKeyFieldName"/>, <paramref name="sourceContext"/> or <paramref name="mappings"/> is null. </exception>
        public SearchIndexerIndexProjectionSelector(string targetIndexName, string parentKeyFieldName, string sourceContext, IEnumerable<InputFieldMappingEntry> mappings)
        {
            Argument.AssertNotNull(targetIndexName, nameof(targetIndexName));
            Argument.AssertNotNull(parentKeyFieldName, nameof(parentKeyFieldName));
            Argument.AssertNotNull(sourceContext, nameof(sourceContext));
            Argument.AssertNotNull(mappings, nameof(mappings));

            TargetIndexName = targetIndexName;
            ParentKeyFieldName = parentKeyFieldName;
            SourceContext = sourceContext;
            Mappings = mappings.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="SearchIndexerIndexProjectionSelector"/>. </summary>
        /// <param name="targetIndexName"> Name of the search index to project to. Must have a key field with the 'keyword' analyzer set. </param>
        /// <param name="parentKeyFieldName"> Name of the field in the search index to map the parent document's key value to. Must be a string field that is filterable and not the key field. </param>
        /// <param name="sourceContext"> Source context for the projections. Represents the cardinality at which the document will be split into multiple sub documents. </param>
        /// <param name="mappings"> Mappings for the projection, or which source should be mapped to which field in the target index. </param>
        internal SearchIndexerIndexProjectionSelector(string targetIndexName, string parentKeyFieldName, string sourceContext, IList<InputFieldMappingEntry> mappings)
        {
            TargetIndexName = targetIndexName;
            ParentKeyFieldName = parentKeyFieldName;
            SourceContext = sourceContext;
            Mappings = mappings;
        }

        /// <summary> Name of the search index to project to. Must have a key field with the 'keyword' analyzer set. </summary>
        public string TargetIndexName { get; set; }
        /// <summary> Name of the field in the search index to map the parent document's key value to. Must be a string field that is filterable and not the key field. </summary>
        public string ParentKeyFieldName { get; set; }
        /// <summary> Source context for the projections. Represents the cardinality at which the document will be split into multiple sub documents. </summary>
        public string SourceContext { get; set; }
        /// <summary> Mappings for the projection, or which source should be mapped to which field in the target index. </summary>
        public IList<InputFieldMappingEntry> Mappings { get; }
    }
}
