// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Search.Documents.Indexes.Models
{
    public partial class SearchIndexerIndexProjectionSelector : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("targetIndexName"u8);
            writer.WriteStringValue(TargetIndexName);
            writer.WritePropertyName("parentKeyFieldName"u8);
            writer.WriteStringValue(ParentKeyFieldName);
            writer.WritePropertyName("sourceContext"u8);
            writer.WriteStringValue(SourceContext);
            writer.WritePropertyName("mappings"u8);
            writer.WriteStartArray();
            foreach (var item in Mappings)
            {
                writer.WriteObjectValue(item);
            }
            writer.WriteEndArray();
            writer.WriteEndObject();
        }

        internal static SearchIndexerIndexProjectionSelector DeserializeSearchIndexerIndexProjectionSelector(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string targetIndexName = default;
            string parentKeyFieldName = default;
            string sourceContext = default;
            IList<InputFieldMappingEntry> mappings = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("targetIndexName"u8))
                {
                    targetIndexName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("parentKeyFieldName"u8))
                {
                    parentKeyFieldName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sourceContext"u8))
                {
                    sourceContext = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("mappings"u8))
                {
                    List<InputFieldMappingEntry> array = new List<InputFieldMappingEntry>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InputFieldMappingEntry.DeserializeInputFieldMappingEntry(item));
                    }
                    mappings = array;
                    continue;
                }
            }
            return new SearchIndexerIndexProjectionSelector(targetIndexName, parentKeyFieldName, sourceContext, mappings);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SearchIndexerIndexProjectionSelector FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSearchIndexerIndexProjectionSelector(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
