// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Statistics for a given index. Statistics are collected periodically and are not guaranteed to always be up-to-date. </summary>
    public partial class SearchIndexStatistics
    {
        /// <summary> Initializes a new instance of <see cref="SearchIndexStatistics"/>. </summary>
        /// <param name="documentCount"> The number of documents in the index. </param>
        /// <param name="storageSize"> The amount of storage in bytes consumed by the index. </param>
        /// <param name="vectorIndexSize"> The amount of memory in bytes consumed by vectors in the index. </param>
        internal SearchIndexStatistics(long documentCount, long storageSize, long vectorIndexSize)
        {
            DocumentCount = documentCount;
            StorageSize = storageSize;
            VectorIndexSize = vectorIndexSize;
        }

        /// <summary> The number of documents in the index. </summary>
        public long DocumentCount { get; }
        /// <summary> The amount of storage in bytes consumed by the index. </summary>
        public long StorageSize { get; }
        /// <summary> The amount of memory in bytes consumed by vectors in the index. </summary>
        public long VectorIndexSize { get; }
    }
}
