// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Search.Documents.Models
{
    internal static partial class ScoringStatisticsExtensions
    {
        public static string ToSerialString(this ScoringStatistics value) => value switch
        {
            ScoringStatistics.Local => "local",
            ScoringStatistics.Global => "global",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ScoringStatistics value.")
        };

        public static ScoringStatistics ToScoringStatistics(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "local")) return ScoringStatistics.Local;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "global")) return ScoringStatistics.Global;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ScoringStatistics value.");
        }
    }
}
