// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Defines the function used to interpolate score boosting across a range of documents. </summary>
    public enum ScoringFunctionInterpolation
    {
        /// <summary> Boosts scores by a linearly decreasing amount. This is the default interpolation for scoring functions. </summary>
        Linear,
        /// <summary> Boosts scores by a constant factor. </summary>
        Constant,
        /// <summary> Boosts scores by an amount that decreases quadratically. Boosts decrease slowly for higher scores, and more quickly as the scores decrease. This interpolation option is not allowed in tag scoring functions. </summary>
        Quadratic,
        /// <summary> Boosts scores by an amount that decreases logarithmically. Boosts decrease quickly for higher scores, and more slowly as the scores decrease. This interpolation option is not allowed in tag scoring functions. </summary>
        Logarithmic
    }
}
