// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Defines the aggregation function used to combine the results of all the scoring functions in a scoring profile. </summary>
    public enum ScoringFunctionAggregation
    {
        /// <summary> Boost scores by the sum of all scoring function results. </summary>
        Sum,
        /// <summary> Boost scores by the average of all scoring function results. </summary>
        Average,
        /// <summary> Boost scores by the minimum of all scoring function results. </summary>
        Minimum,
        /// <summary> Boost scores by the maximum of all scoring function results. </summary>
        Maximum,
        /// <summary> Boost scores using the first applicable scoring function in the scoring profile. </summary>
        FirstMatching
    }
}
