// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.Search.Documents.Indexes.Models
{
    public partial class ScalarQuantizationParameters : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(QuantizedDataType))
            {
                if (QuantizedDataType != null)
                {
                    writer.WritePropertyName("quantizedDataType"u8);
                    writer.WriteStringValue(QuantizedDataType.Value.ToString());
                }
                else
                {
                    writer.WriteNull("quantizedDataType");
                }
            }
            writer.WriteEndObject();
        }

        internal static ScalarQuantizationParameters DeserializeScalarQuantizationParameters(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            VectorSearchCompressionTarget? quantizedDataType = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("quantizedDataType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        quantizedDataType = null;
                        continue;
                    }
                    quantizedDataType = new VectorSearchCompressionTarget(property.Value.GetString());
                    continue;
                }
            }
            return new ScalarQuantizationParameters(quantizedDataType);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ScalarQuantizationParameters FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeScalarQuantizationParameters(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
