// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Search.Documents.Models
{
    /// <summary> The DocumentKeysOrIds. </summary>
    public partial class ResetDocumentOptions
    {
        /// <summary> Initializes a new instance of <see cref="ResetDocumentOptions"/>. </summary>
        public ResetDocumentOptions()
        {
            DocumentKeys = new ChangeTrackingList<string>();
            DataSourceDocumentIds = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ResetDocumentOptions"/>. </summary>
        /// <param name="documentKeys"> document keys to be reset. </param>
        /// <param name="dataSourceDocumentIds"> datasource document identifiers to be reset. </param>
        internal ResetDocumentOptions(IList<string> documentKeys, IList<string> dataSourceDocumentIds)
        {
            DocumentKeys = documentKeys;
            DataSourceDocumentIds = dataSourceDocumentIds;
        }

        /// <summary> document keys to be reset. </summary>
        public IList<string> DocumentKeys { get; }
    }
}
