// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Defines flags that can be combined to control how regular expressions are used in the pattern analyzer and pattern tokenizer. </summary>
    public readonly partial struct RegexFlag : IEquatable<RegexFlag>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RegexFlag"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RegexFlag(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CanonEqValue = "CANON_EQ";
        private const string CaseInsensitiveValue = "CASE_INSENSITIVE";
        private const string CommentsValue = "COMMENTS";
        private const string DotAllValue = "DOTALL";
        private const string LiteralValue = "LITERAL";
        private const string MultilineValue = "MULTILINE";
        private const string UnicodeCaseValue = "UNICODE_CASE";
        private const string UnixLinesValue = "UNIX_LINES";

        /// <summary> Enables canonical equivalence. </summary>
        public static RegexFlag CanonEq { get; } = new RegexFlag(CanonEqValue);
        /// <summary> Enables case-insensitive matching. </summary>
        public static RegexFlag CaseInsensitive { get; } = new RegexFlag(CaseInsensitiveValue);
        /// <summary> Permits whitespace and comments in the pattern. </summary>
        public static RegexFlag Comments { get; } = new RegexFlag(CommentsValue);
        /// <summary> Enables dotall mode. </summary>
        public static RegexFlag DotAll { get; } = new RegexFlag(DotAllValue);
        /// <summary> Enables literal parsing of the pattern. </summary>
        public static RegexFlag Literal { get; } = new RegexFlag(LiteralValue);
        /// <summary> Enables multiline mode. </summary>
        public static RegexFlag Multiline { get; } = new RegexFlag(MultilineValue);
        /// <summary> Enables Unicode-aware case folding. </summary>
        public static RegexFlag UnicodeCase { get; } = new RegexFlag(UnicodeCaseValue);
        /// <summary> Enables Unix lines mode. </summary>
        public static RegexFlag UnixLines { get; } = new RegexFlag(UnixLinesValue);
        /// <summary> Determines if two <see cref="RegexFlag"/> values are the same. </summary>
        public static bool operator ==(RegexFlag left, RegexFlag right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RegexFlag"/> values are not the same. </summary>
        public static bool operator !=(RegexFlag left, RegexFlag right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RegexFlag"/>. </summary>
        public static implicit operator RegexFlag(string value) => new RegexFlag(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RegexFlag other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RegexFlag other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
