// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Models
{
    /// <summary> Improve search recall by spell-correcting individual search query terms. </summary>
    public readonly partial struct QuerySpellerType : IEquatable<QuerySpellerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="QuerySpellerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public QuerySpellerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "none";
        private const string LexiconValue = "lexicon";

        /// <summary> Speller not enabled. </summary>
        public static QuerySpellerType None { get; } = new QuerySpellerType(NoneValue);
        /// <summary> Speller corrects individual query terms using a static lexicon for the language specified by the queryLanguage parameter. </summary>
        public static QuerySpellerType Lexicon { get; } = new QuerySpellerType(LexiconValue);
        /// <summary> Determines if two <see cref="QuerySpellerType"/> values are the same. </summary>
        public static bool operator ==(QuerySpellerType left, QuerySpellerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="QuerySpellerType"/> values are not the same. </summary>
        public static bool operator !=(QuerySpellerType left, QuerySpellerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="QuerySpellerType"/>. </summary>
        public static implicit operator QuerySpellerType(string value) => new QuerySpellerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is QuerySpellerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(QuerySpellerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
