// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Models
{
    /// <summary> Enables a debugging tool that can be used to further explore your search results. </summary>
    public readonly partial struct QueryDebugMode : IEquatable<QueryDebugMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="QueryDebugMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public QueryDebugMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "disabled";
        private const string SemanticValue = "semantic";

        /// <summary> No query debugging information will be returned. </summary>
        public static QueryDebugMode Disabled { get; } = new QueryDebugMode(DisabledValue);
        /// <summary> Allows the user to further explore their reranked results. </summary>
        public static QueryDebugMode Semantic { get; } = new QueryDebugMode(SemanticValue);
        /// <summary> Determines if two <see cref="QueryDebugMode"/> values are the same. </summary>
        public static bool operator ==(QueryDebugMode left, QueryDebugMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="QueryDebugMode"/> values are not the same. </summary>
        public static bool operator !=(QueryDebugMode left, QueryDebugMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="QueryDebugMode"/>. </summary>
        public static implicit operator QueryDebugMode(string value) => new QueryDebugMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is QueryDebugMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(QueryDebugMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
