// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Models
{
    /// <summary> This parameter is only valid if the query type is `semantic`. If set, the query returns answers extracted from key passages in the highest ranked documents. The number of answers returned can be configured by appending the pipe character `|` followed by the `count-&lt;number of answers&gt;` option after the answers parameter value, such as `extractive|count-3`. Default count is 1. The confidence threshold can be configured by appending the pipe character `|` followed by the `threshold-&lt;confidence threshold&gt;` option after the answers parameter value, such as `extractive|threshold-0.9`. Default threshold is 0.7. </summary>
    public readonly partial struct QueryAnswerType : IEquatable<QueryAnswerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="QueryAnswerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public QueryAnswerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "none";
        private const string ExtractiveValue = "extractive";

        /// <summary> Do not return answers for the query. </summary>
        public static QueryAnswerType None { get; } = new QueryAnswerType(NoneValue);
        /// <summary> Extracts answer candidates from the contents of the documents returned in response to a query expressed as a question in natural language. </summary>
        public static QueryAnswerType Extractive { get; } = new QueryAnswerType(ExtractiveValue);
        /// <summary> Determines if two <see cref="QueryAnswerType"/> values are the same. </summary>
        public static bool operator ==(QueryAnswerType left, QueryAnswerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="QueryAnswerType"/> values are not the same. </summary>
        public static bool operator !=(QueryAnswerType left, QueryAnswerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="QueryAnswerType"/>. </summary>
        public static implicit operator QueryAnswerType(string value) => new QueryAnswerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is QueryAnswerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(QueryAnswerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
