// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Search.Documents.Indexes.Models
{
    internal partial class ListSynonymMapsResult
    {
        internal static ListSynonymMapsResult DeserializeListSynonymMapsResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<SynonymMap> value = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    List<SynonymMap> array = new List<SynonymMap>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SynonymMap.DeserializeSynonymMap(item));
                    }
                    value = array;
                    continue;
                }
            }
            return new ListSynonymMapsResult(value);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ListSynonymMapsResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeListSynonymMapsResult(document.RootElement);
        }
    }
}
