// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Linq;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Response from a List Indexers request. If successful, it includes the full definitions of all indexers. </summary>
    internal partial class ListIndexersResult
    {
        /// <summary> Initializes a new instance of <see cref="ListIndexersResult"/>. </summary>
        /// <param name="indexers"> The indexers in the Search service. </param>
        internal ListIndexersResult(IEnumerable<SearchIndexer> indexers)
        {
            Indexers = indexers.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ListIndexersResult"/>. </summary>
        /// <param name="indexers"> The indexers in the Search service. </param>
        internal ListIndexersResult(IReadOnlyList<SearchIndexer> indexers)
        {
            Indexers = indexers;
        }

        /// <summary> The indexers in the Search service. </summary>
        public IReadOnlyList<SearchIndexer> Indexers { get; }
    }
}
