// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Search.Documents.Indexes.Models
{
    internal partial class ListDataSourcesResult
    {
        internal static ListDataSourcesResult DeserializeListDataSourcesResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<SearchIndexerDataSourceConnection> value = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    List<SearchIndexerDataSourceConnection> array = new List<SearchIndexerDataSourceConnection>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SearchIndexerDataSourceConnection.DeserializeSearchIndexerDataSourceConnection(item));
                    }
                    value = array;
                    continue;
                }
            }
            return new ListDataSourcesResult(value);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ListDataSourcesResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeListDataSourcesResult(document.RootElement);
        }
    }
}
