// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Linq;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Response from a List Aliases request. If successful, it includes the associated index mappings for all aliases. </summary>
    internal partial class ListAliasesResult
    {
        /// <summary> Initializes a new instance of <see cref="ListAliasesResult"/>. </summary>
        /// <param name="aliases"> The aliases in the Search service. </param>
        internal ListAliasesResult(IEnumerable<SearchAlias> aliases)
        {
            Aliases = aliases.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ListAliasesResult"/>. </summary>
        /// <param name="aliases"> The aliases in the Search service. </param>
        internal ListAliasesResult(IReadOnlyList<SearchAlias> aliases)
        {
            Aliases = aliases;
        }

        /// <summary> The aliases in the Search service. </summary>
        public IReadOnlyList<SearchAlias> Aliases { get; }
    }
}
