// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Search.Documents.Indexes.Models
{
    internal partial class ListAliasesResult
    {
        internal static ListAliasesResult DeserializeListAliasesResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<SearchAlias> value = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    List<SearchAlias> array = new List<SearchAlias>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SearchAlias.DeserializeSearchAlias(item));
                    }
                    value = array;
                    continue;
                }
            }
            return new ListAliasesResult(value);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ListAliasesResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeListAliasesResult(document.RootElement);
        }
    }
}
