// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Defines the names of all text normalizers supported by the search engine. </summary>
    public readonly partial struct LexicalNormalizerName : IEquatable<LexicalNormalizerName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LexicalNormalizerName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LexicalNormalizerName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AsciiFoldingValue = "asciifolding";
        private const string ElisionValue = "elision";
        private const string LowercaseValue = "lowercase";
        private const string StandardValue = "standard";
        private const string UppercaseValue = "uppercase";

        /// <summary> Converts alphabetic, numeric, and symbolic Unicode characters which are not in the first 127 ASCII characters (the "Basic Latin" Unicode block) into their ASCII equivalents, if such equivalents exist. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/miscellaneous/ASCIIFoldingFilter.html. </summary>
        public static LexicalNormalizerName AsciiFolding { get; } = new LexicalNormalizerName(AsciiFoldingValue);
        /// <summary> Removes elisions. For example, "l'avion" (the plane) will be converted to "avion" (plane). See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/util/ElisionFilter.html. </summary>
        public static LexicalNormalizerName Elision { get; } = new LexicalNormalizerName(ElisionValue);
        /// <summary> Normalizes token text to lowercase. See https://lucene.apache.org/core/6_6_1/analyzers-common/org/apache/lucene/analysis/core/LowerCaseFilter.html. </summary>
        public static LexicalNormalizerName Lowercase { get; } = new LexicalNormalizerName(LowercaseValue);
        /// <summary> Standard normalizer, which consists of lowercase and asciifolding. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/reverse/ReverseStringFilter.html. </summary>
        public static LexicalNormalizerName Standard { get; } = new LexicalNormalizerName(StandardValue);
        /// <summary> Normalizes token text to uppercase. See https://lucene.apache.org/core/6_6_1/analyzers-common/org/apache/lucene/analysis/core/UpperCaseFilter.html. </summary>
        public static LexicalNormalizerName Uppercase { get; } = new LexicalNormalizerName(UppercaseValue);
        /// <summary> Determines if two <see cref="LexicalNormalizerName"/> values are the same. </summary>
        public static bool operator ==(LexicalNormalizerName left, LexicalNormalizerName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LexicalNormalizerName"/> values are not the same. </summary>
        public static bool operator !=(LexicalNormalizerName left, LexicalNormalizerName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LexicalNormalizerName"/>. </summary>
        public static implicit operator LexicalNormalizerName(string value) => new LexicalNormalizerName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LexicalNormalizerName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LexicalNormalizerName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
