// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Description for what data to store in Azure Tables. </summary>
    public partial class KnowledgeStoreTableProjectionSelector : KnowledgeStoreProjectionSelector
    {
        /// <summary> Initializes a new instance of <see cref="KnowledgeStoreTableProjectionSelector"/>. </summary>
        /// <param name="tableName"> Name of the Azure table to store projected data in. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="tableName"/> is null. </exception>
        public KnowledgeStoreTableProjectionSelector(string tableName)
        {
            Argument.AssertNotNull(tableName, nameof(tableName));

            TableName = tableName;
        }

        /// <summary> Initializes a new instance of <see cref="KnowledgeStoreTableProjectionSelector"/>. </summary>
        /// <param name="referenceKeyName"> Name of reference key to different projection. </param>
        /// <param name="generatedKeyName"> Name of generated key to store projection under. </param>
        /// <param name="source"> Source data to project. </param>
        /// <param name="sourceContext"> Source context for complex projections. </param>
        /// <param name="inputs"> Nested inputs for complex projections. </param>
        /// <param name="tableName"> Name of the Azure table to store projected data in. </param>
        internal KnowledgeStoreTableProjectionSelector(string referenceKeyName, string generatedKeyName, string source, string sourceContext, IList<InputFieldMappingEntry> inputs, string tableName) : base(referenceKeyName, generatedKeyName, source, sourceContext, inputs)
        {
            TableName = tableName;
        }

        /// <summary> Name of the Azure table to store projected data in. </summary>
        public string TableName { get; set; }
    }
}
