// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Search.Documents.Indexes.Models
{
    public partial class IndexingParametersConfiguration : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(ParsingMode))
            {
                writer.WritePropertyName("parsingMode"u8);
                writer.WriteStringValue(ParsingMode.Value.ToString());
            }
            if (Optional.IsDefined(ExcludedFileNameExtensions))
            {
                writer.WritePropertyName("excludedFileNameExtensions"u8);
                writer.WriteStringValue(ExcludedFileNameExtensions);
            }
            if (Optional.IsDefined(IndexedFileNameExtensions))
            {
                writer.WritePropertyName("indexedFileNameExtensions"u8);
                writer.WriteStringValue(IndexedFileNameExtensions);
            }
            if (Optional.IsDefined(FailOnUnsupportedContentType))
            {
                writer.WritePropertyName("failOnUnsupportedContentType"u8);
                writer.WriteBooleanValue(FailOnUnsupportedContentType.Value);
            }
            if (Optional.IsDefined(FailOnUnprocessableDocument))
            {
                writer.WritePropertyName("failOnUnprocessableDocument"u8);
                writer.WriteBooleanValue(FailOnUnprocessableDocument.Value);
            }
            if (Optional.IsDefined(IndexStorageMetadataOnlyForOversizedDocuments))
            {
                writer.WritePropertyName("indexStorageMetadataOnlyForOversizedDocuments"u8);
                writer.WriteBooleanValue(IndexStorageMetadataOnlyForOversizedDocuments.Value);
            }
            if (Optional.IsDefined(DelimitedTextHeaders))
            {
                writer.WritePropertyName("delimitedTextHeaders"u8);
                writer.WriteStringValue(DelimitedTextHeaders);
            }
            if (Optional.IsDefined(DelimitedTextDelimiter))
            {
                writer.WritePropertyName("delimitedTextDelimiter"u8);
                writer.WriteStringValue(DelimitedTextDelimiter);
            }
            if (Optional.IsDefined(FirstLineContainsHeaders))
            {
                writer.WritePropertyName("firstLineContainsHeaders"u8);
                writer.WriteBooleanValue(FirstLineContainsHeaders.Value);
            }
            if (Optional.IsDefined(DocumentRoot))
            {
                writer.WritePropertyName("documentRoot"u8);
                writer.WriteStringValue(DocumentRoot);
            }
            if (Optional.IsDefined(DataToExtract))
            {
                writer.WritePropertyName("dataToExtract"u8);
                writer.WriteStringValue(DataToExtract.Value.ToString());
            }
            if (Optional.IsDefined(ImageAction))
            {
                writer.WritePropertyName("imageAction"u8);
                writer.WriteStringValue(ImageAction.Value.ToString());
            }
            if (Optional.IsDefined(AllowSkillsetToReadFileData))
            {
                writer.WritePropertyName("allowSkillsetToReadFileData"u8);
                writer.WriteBooleanValue(AllowSkillsetToReadFileData.Value);
            }
            if (Optional.IsDefined(PdfTextRotationAlgorithm))
            {
                writer.WritePropertyName("pdfTextRotationAlgorithm"u8);
                writer.WriteStringValue(PdfTextRotationAlgorithm.Value.ToString());
            }
            if (Optional.IsDefined(ExecutionEnvironment))
            {
                writer.WritePropertyName("executionEnvironment"u8);
                writer.WriteStringValue(ExecutionEnvironment.Value.ToString());
            }
            if (Optional.IsDefined(_queryTimeout))
            {
                writer.WritePropertyName("queryTimeout"u8);
                writer.WriteStringValue(_queryTimeout);
            }
            foreach (var item in AdditionalProperties)
            {
                writer.WritePropertyName(item.Key);
                writer.WriteObjectValue<object>(item.Value);
            }
            writer.WriteEndObject();
        }

        internal static IndexingParametersConfiguration DeserializeIndexingParametersConfiguration(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            BlobIndexerParsingMode? parsingMode = default;
            string excludedFileNameExtensions = default;
            string indexedFileNameExtensions = default;
            bool? failOnUnsupportedContentType = default;
            bool? failOnUnprocessableDocument = default;
            bool? indexStorageMetadataOnlyForOversizedDocuments = default;
            string delimitedTextHeaders = default;
            string delimitedTextDelimiter = default;
            bool? firstLineContainsHeaders = default;
            string documentRoot = default;
            BlobIndexerDataToExtract? dataToExtract = default;
            BlobIndexerImageAction? imageAction = default;
            bool? allowSkillsetToReadFileData = default;
            BlobIndexerPdfTextRotationAlgorithm? pdfTextRotationAlgorithm = default;
            IndexerExecutionEnvironment? executionEnvironment = default;
            string queryTimeout = default;
            IDictionary<string, object> additionalProperties = default;
            Dictionary<string, object> additionalPropertiesDictionary = new Dictionary<string, object>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("parsingMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    parsingMode = new BlobIndexerParsingMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("excludedFileNameExtensions"u8))
                {
                    excludedFileNameExtensions = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("indexedFileNameExtensions"u8))
                {
                    indexedFileNameExtensions = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("failOnUnsupportedContentType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    failOnUnsupportedContentType = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("failOnUnprocessableDocument"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    failOnUnprocessableDocument = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("indexStorageMetadataOnlyForOversizedDocuments"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    indexStorageMetadataOnlyForOversizedDocuments = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("delimitedTextHeaders"u8))
                {
                    delimitedTextHeaders = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("delimitedTextDelimiter"u8))
                {
                    delimitedTextDelimiter = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("firstLineContainsHeaders"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    firstLineContainsHeaders = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("documentRoot"u8))
                {
                    documentRoot = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("dataToExtract"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataToExtract = new BlobIndexerDataToExtract(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("imageAction"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    imageAction = new BlobIndexerImageAction(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("allowSkillsetToReadFileData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allowSkillsetToReadFileData = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("pdfTextRotationAlgorithm"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pdfTextRotationAlgorithm = new BlobIndexerPdfTextRotationAlgorithm(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("executionEnvironment"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    executionEnvironment = new IndexerExecutionEnvironment(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("queryTimeout"u8))
                {
                    queryTimeout = property.Value.GetString();
                    continue;
                }
                additionalPropertiesDictionary.Add(property.Name, property.Value.GetObject());
            }
            additionalProperties = additionalPropertiesDictionary;
            return new IndexingParametersConfiguration(
                parsingMode,
                excludedFileNameExtensions,
                indexedFileNameExtensions,
                failOnUnsupportedContentType,
                failOnUnprocessableDocument,
                indexStorageMetadataOnlyForOversizedDocuments,
                delimitedTextHeaders,
                delimitedTextDelimiter,
                firstLineContainsHeaders,
                documentRoot,
                dataToExtract,
                imageAction,
                allowSkillsetToReadFileData,
                pdfTextRotationAlgorithm,
                executionEnvironment,
                queryTimeout,
                additionalProperties);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static IndexingParametersConfiguration FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeIndexingParametersConfiguration(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
