// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.Search.Documents.Indexes.Models
{
    public partial class IndexingParameters : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(BatchSize))
            {
                if (BatchSize != null)
                {
                    writer.WritePropertyName("batchSize"u8);
                    writer.WriteNumberValue(BatchSize.Value);
                }
                else
                {
                    writer.WriteNull("batchSize");
                }
            }
            if (Optional.IsDefined(MaxFailedItems))
            {
                if (MaxFailedItems != null)
                {
                    writer.WritePropertyName("maxFailedItems"u8);
                    writer.WriteNumberValue(MaxFailedItems.Value);
                }
                else
                {
                    writer.WriteNull("maxFailedItems");
                }
            }
            if (Optional.IsDefined(MaxFailedItemsPerBatch))
            {
                if (MaxFailedItemsPerBatch != null)
                {
                    writer.WritePropertyName("maxFailedItemsPerBatch"u8);
                    writer.WriteNumberValue(MaxFailedItemsPerBatch.Value);
                }
                else
                {
                    writer.WriteNull("maxFailedItemsPerBatch");
                }
            }
            if (Optional.IsDefined(IndexingParametersConfiguration))
            {
                writer.WritePropertyName("configuration"u8);
                writer.WriteObjectValue<IndexingParametersConfiguration>(IndexingParametersConfiguration);
            }
            writer.WriteEndObject();
        }

        internal static IndexingParameters DeserializeIndexingParameters(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? batchSize = default;
            int? maxFailedItems = default;
            int? maxFailedItemsPerBatch = default;
            IndexingParametersConfiguration configuration = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("batchSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        batchSize = null;
                        continue;
                    }
                    batchSize = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxFailedItems"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        maxFailedItems = null;
                        continue;
                    }
                    maxFailedItems = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxFailedItemsPerBatch"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        maxFailedItemsPerBatch = null;
                        continue;
                    }
                    maxFailedItemsPerBatch = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("configuration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    configuration = Models.IndexingParametersConfiguration.DeserializeIndexingParametersConfiguration(property.Value);
                    continue;
                }
            }
            return new IndexingParameters(batchSize, maxFailedItems, maxFailedItemsPerBatch, configuration);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static IndexingParameters FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeIndexingParameters(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
