// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Represents all of the state that defines and dictates the indexer's current execution. </summary>
    public partial class IndexerState
    {
        /// <summary> Initializes a new instance of <see cref="IndexerState"/>. </summary>
        internal IndexerState()
        {
            ResetDocumentKeys = new ChangeTrackingList<string>();
            ResetDataSourceDocumentIds = new ChangeTrackingList<string>();
        }

        /// <summary> The mode the indexer is running in. </summary>
        public IndexingMode? Mode { get; }
        /// <summary> The list of document keys that have been reset. The document key is the document's unique identifier for the data in the search index. The indexer will prioritize selectively re-ingesting these keys. </summary>
        public IReadOnlyList<string> ResetDocumentKeys { get; }
    }
}
