// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Details the status of an individual indexer execution. </summary>
    public readonly partial struct IndexerExecutionStatusDetail : IEquatable<IndexerExecutionStatusDetail>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IndexerExecutionStatusDetail"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IndexerExecutionStatusDetail(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ResetDocsValue = "resetDocs";

        /// <summary> Indicates that the reset that occurred was for a call to ResetDocs. </summary>
        public static IndexerExecutionStatusDetail ResetDocs { get; } = new IndexerExecutionStatusDetail(ResetDocsValue);
        /// <summary> Determines if two <see cref="IndexerExecutionStatusDetail"/> values are the same. </summary>
        public static bool operator ==(IndexerExecutionStatusDetail left, IndexerExecutionStatusDetail right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IndexerExecutionStatusDetail"/> values are not the same. </summary>
        public static bool operator !=(IndexerExecutionStatusDetail left, IndexerExecutionStatusDetail right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IndexerExecutionStatusDetail"/>. </summary>
        public static implicit operator IndexerExecutionStatusDetail(string value) => new IndexerExecutionStatusDetail(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IndexerExecutionStatusDetail other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IndexerExecutionStatusDetail other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
