// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Specifies the environment in which the indexer should execute. </summary>
    public readonly partial struct IndexerExecutionEnvironment : IEquatable<IndexerExecutionEnvironment>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IndexerExecutionEnvironment"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IndexerExecutionEnvironment(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "standard";
        private const string PrivateValue = "private";

        /// <summary> Indicates that the search service can determine where the indexer should execute. This is the default environment when nothing is specified and is the recommended value. </summary>
        public static IndexerExecutionEnvironment Standard { get; } = new IndexerExecutionEnvironment(StandardValue);
        /// <summary> Indicates that the indexer should run with the environment provisioned specifically for the search service. This should only be specified as the execution environment if the indexer needs to access resources securely over shared private link resources. </summary>
        public static IndexerExecutionEnvironment Private { get; } = new IndexerExecutionEnvironment(PrivateValue);
        /// <summary> Determines if two <see cref="IndexerExecutionEnvironment"/> values are the same. </summary>
        public static bool operator ==(IndexerExecutionEnvironment left, IndexerExecutionEnvironment right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IndexerExecutionEnvironment"/> values are not the same. </summary>
        public static bool operator !=(IndexerExecutionEnvironment left, IndexerExecutionEnvironment right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IndexerExecutionEnvironment"/>. </summary>
        public static implicit operator IndexerExecutionEnvironment(string value) => new IndexerExecutionEnvironment(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IndexerExecutionEnvironment other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IndexerExecutionEnvironment other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
