// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Defines behavior of the index projections in relation to the rest of the indexer. </summary>
    public readonly partial struct IndexProjectionMode : IEquatable<IndexProjectionMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IndexProjectionMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IndexProjectionMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SkipIndexingParentDocumentsValue = "skipIndexingParentDocuments";
        private const string IncludeIndexingParentDocumentsValue = "includeIndexingParentDocuments";

        /// <summary> The source document will be skipped from writing into the indexer's target index. </summary>
        public static IndexProjectionMode SkipIndexingParentDocuments { get; } = new IndexProjectionMode(SkipIndexingParentDocumentsValue);
        /// <summary> The source document will be written into the indexer's target index. This is the default pattern. </summary>
        public static IndexProjectionMode IncludeIndexingParentDocuments { get; } = new IndexProjectionMode(IncludeIndexingParentDocumentsValue);
        /// <summary> Determines if two <see cref="IndexProjectionMode"/> values are the same. </summary>
        public static bool operator ==(IndexProjectionMode left, IndexProjectionMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IndexProjectionMode"/> values are not the same. </summary>
        public static bool operator !=(IndexProjectionMode left, IndexProjectionMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IndexProjectionMode"/>. </summary>
        public static implicit operator IndexProjectionMode(string value) => new IndexProjectionMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IndexProjectionMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IndexProjectionMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
