// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Linq;

namespace Azure.Search.Documents.Models
{
    /// <summary> Response containing the status of operations for all documents in the indexing request. </summary>
    public partial class IndexDocumentsResult
    {
        /// <summary> Initializes a new instance of <see cref="IndexDocumentsResult"/>. </summary>
        /// <param name="results"> The list of status information for each document in the indexing request. </param>
        internal IndexDocumentsResult(IEnumerable<IndexingResult> results)
        {
            Results = results.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="IndexDocumentsResult"/>. </summary>
        /// <param name="results"> The list of status information for each document in the indexing request. </param>
        internal IndexDocumentsResult(IReadOnlyList<IndexingResult> results)
        {
            Results = results;
        }

        /// <summary> The list of status information for each document in the indexing request. </summary>
        public IReadOnlyList<IndexingResult> Results { get; }
    }
}
