// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Models
{
    /// <summary> Determines whether the count and facets should includes all documents that matched the search query, or only the documents that are retrieved within the 'maxTextRecallSize' window. The default value is 'countAllResults'. </summary>
    public readonly partial struct HybridCountAndFacetMode : IEquatable<HybridCountAndFacetMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridCountAndFacetMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridCountAndFacetMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CountRetrievableResultsValue = "countRetrievableResults";
        private const string CountAllResultsValue = "countAllResults";

        /// <summary> Only include documents that were matched within the 'maxTextRecallSize' retrieval window when computing 'count' and 'facets'. </summary>
        public static HybridCountAndFacetMode CountRetrievableResults { get; } = new HybridCountAndFacetMode(CountRetrievableResultsValue);
        /// <summary> Include all documents that were matched by the search query when computing 'count' and 'facets', regardless of whether or not those documents are within the 'maxTextRecallSize' retrieval window. </summary>
        public static HybridCountAndFacetMode CountAllResults { get; } = new HybridCountAndFacetMode(CountAllResultsValue);
        /// <summary> Determines if two <see cref="HybridCountAndFacetMode"/> values are the same. </summary>
        public static bool operator ==(HybridCountAndFacetMode left, HybridCountAndFacetMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridCountAndFacetMode"/> values are not the same. </summary>
        public static bool operator !=(HybridCountAndFacetMode left, HybridCountAndFacetMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridCountAndFacetMode"/>. </summary>
        public static implicit operator HybridCountAndFacetMode(string value) => new HybridCountAndFacetMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridCountAndFacetMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridCountAndFacetMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
