// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.Search.Documents.Indexes.Models
{
    public partial class FieldMapping : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("sourceFieldName"u8);
            writer.WriteStringValue(SourceFieldName);
            if (Optional.IsDefined(TargetFieldName))
            {
                writer.WritePropertyName("targetFieldName"u8);
                writer.WriteStringValue(TargetFieldName);
            }
            if (Optional.IsDefined(MappingFunction))
            {
                if (MappingFunction != null)
                {
                    writer.WritePropertyName("mappingFunction"u8);
                    writer.WriteObjectValue(MappingFunction);
                }
                else
                {
                    writer.WriteNull("mappingFunction");
                }
            }
            writer.WriteEndObject();
        }

        internal static FieldMapping DeserializeFieldMapping(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string sourceFieldName = default;
            string targetFieldName = default;
            FieldMappingFunction mappingFunction = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sourceFieldName"u8))
                {
                    sourceFieldName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetFieldName"u8))
                {
                    targetFieldName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("mappingFunction"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        mappingFunction = null;
                        continue;
                    }
                    mappingFunction = FieldMappingFunction.DeserializeFieldMappingFunction(property.Value);
                    continue;
                }
            }
            return new FieldMapping(sourceFieldName, targetFieldName, mappingFunction);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static FieldMapping FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeFieldMapping(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
